// returns an array of tile objects that are within this range of the given tile
// precond: range > 0
function getCoordsWithinRange(tile, range)
{
if(range<0) return;

// in TB, a tile is within range n of another tile if deltaX + deltaY <= n

// var size = (1+range*2) * (1+range*2);
var points = new Array();

for (var x = tile.X-range; x<= tile.X+range; x++)
{
for (var y = tile.Y-range; y<= tile.Y+range; y++)
{
var deltaX = Math.abs(x - tile.X);
var deltaY = Math.abs(y - tile.Y);
if (x>=0 && y >= 0 && deltaX + deltaY <= range)
{
points.push(shared.Map.GetTile(x,y));
}
}
}

return points;
}

// calculates the distance between 2 tiles s and t
function calcDistance(s, t)
{
// distance = deltaX + deltaY
var deltaX = Math.abs(s.X - t.X);
var deltaY = Math.abs(s.Y - t.Y);

return deltaX + deltaY;
}